<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Flashcards;
use Artisan;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\URL;

class FlashcardsController extends Controller
{
    public function general_setting()
    {
        $items = Flashcards::where('theme', get_setting('homepage_select'))->get();

        if ($items->isNotEmpty()) {
            $transformedArray = $items->map(function($item) {
                return [$item->type => $item->value];
            })->reduce(function($carry, $item) {
                return array_merge($carry, $item);
            }, []);
            $item = (object) $transformedArray;
        } else {
            dd('Nenhum item encontrado');
        }
        return view('backend.themes.' . get_setting('homepage_select') . '.flashcard.edit', compact('item'));
    }

    public function update(Request $request)
    {
        foreach ($request->types as $key => $type) {
            if (gettype($type) == 'array') {
                $lang = array_key_first($type);
                $type = $type[$lang];
                $business_settings = Flashcards::where('type', $type)->where('lang', $lang)->first();
            } else {
                $business_settings = Flashcards::where('type', $type)->first();
            }

            if ($business_settings != null) {
                if (gettype($request[$type]) == 'array') {
                    $business_settings->value = json_encode($request[$type]);
                } else {
                    $business_settings->value = $request[$type];
                }
                $business_settings->theme = get_setting('homepage_select');
                $business_settings->save();
            } else {
                $business_settings = new Flashcards;
                $business_settings->theme = get_setting('homepage_select');
                $business_settings->type = $type;
                if (gettype($request[$type]) == 'array') {
                    $business_settings->value = json_encode($request[$type]);
                } else {
                    $business_settings->value = $request[$type];
                }
                $business_settings->save();
            }
        }

        Artisan::call('cache:clear');

        flash(translate("Configurações atualizadas com sucesso"))->success();
        if ($request->has('tab')) {
            return Redirect::to(URL::previous() . "#" . $request->tab);
        }
        return redirect()->back();
    }
}