<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Servicesall;
use App\Models\ServicesPagesall;
use Artisan;
use CoreComponentRepository;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\URL;
use Str;

class ServicoallController extends Controller
{

    public function index(Request $request)
    {
        $sort_search = null;
        $query = Servicesall::query();
        if ($request->search != null) {
            $query->where('title', 'like', '%' . $request->search . '%');
            $sort_search = $request->search;
        }
        $items = $query->paginate(15);
        return view('backend.themes.' . get_setting('homepage_select') . '.servicoall.index', compact('items', 'sort_search'));
    }
    public function duplicate(Request $request, $id)
    {
        $originalItem = Servicesall::find($id);
        if (!$originalItem) {
            return redirect()->route('servico.index')->with('error', 'Item não encontrado.');
        }
        $newItem = $originalItem->replicate();
        $newItem->slug = Str::slug(Str::random(10));
        $newItem->save();
        $relatedItems = ServicesPagesall::where('theme', get_setting('homepage_select'))
            ->where('id_service', $originalItem->id)
            ->get();
        foreach ($relatedItems as $relatedItem) {
            $newRelatedItem = $relatedItem->replicate();
            $newRelatedItem->id_service = $newItem->id;
            $newRelatedItem->save();
        }
        return redirect()->route('servicoall.edit', $newItem->id)->with('success', 'Item duplicado com sucesso.');
    }
    public function create()
    {
        $item = new Servicesall();
        $item->title = Str::random(10);
        $item->slug = Str::slug(Str::random(10));
        $item->save();
        
        $relatedItems = ServicesPagesall::where('theme', get_setting('homepage_select'))
            ->where('id_service', 0)
            ->get();
        foreach ($relatedItems as $relatedItem) {
            $newRelatedItem = $relatedItem->replicate();
            $newRelatedItem->id_service = $item->id;
            $newRelatedItem->save();
        }
    
        return redirect()->route('servicoall.edit', $item->id);
    }


    public function edit($id)
    {
        $itemnew = Servicesall::find($id);
        $items = ServicesPagesall::where('theme', get_setting('homepage_select'))->where('id_service',$itemnew->id)->get();

        if ($items->isNotEmpty()) {
            $transformedArray = $items->map(function($item) {
                return [$item->type => $item->value];
            })->reduce(function($carry, $item) {
                return array_merge($carry, $item);
            }, []);
            $item = (object) $transformedArray;
        } else {
            $item = (object) [];
        }
        return view('backend.themes.' . get_setting('homepage_select') . '.servicoall.edit', compact('item','itemnew'));
    }

    public function destroy($id)
    {
        Servicesall::find($id)->delete();
        $relatedServicos = ServicesPagesall::where('id_service', $id)->get();
        if ($relatedServicos->isNotEmpty()) {
            foreach ($relatedServicos as $relatedServico) {
                $relatedServico->delete();
            }
        }
        return redirect()->back();
    }

    public function general_setting()
    {
        $items = ServicesPagesall::where('theme', get_setting('homepage_select'))->get();

        if ($items->isNotEmpty()) {
            $transformedArray = $items->map(function($item) {
                return [$item->type => $item->value];
            })->reduce(function($carry, $item) {
                return array_merge($carry, $item);
            }, []);
            $item = (object) $transformedArray;
        } else {
            dd('Nenhum item encontrado');
        }

        return view('backend.themes.servicoall.' . get_setting('homepage_select') . '.edit', compact('item'));
    }

    public function all_servico(){
        $services = Servicesall::all();
        return view("frontend.".get_setting('homepage_select').".servico", compact('services'));
    }
    public function change_status(Request $request) {
        $item = Servicesall::find($request->id);
        $item->status = $request->status;
        $item->save();
        return 1;
    }
    public function update(Request $request,$id){
        $item = Servicesall::find($id);
        $item->title = $request->title ?? '';
        $item->subtitle = $request->subtitle ?? '';
        $item->image = $request->image ?? '';
        $item->slug = $request->slug ?? '';
        $item->categoria = $request->categoria ?? '';
        $item->meta_title = $request->meta_title ?? '';
        $item->meta_description = $request->meta_description ?? '';
        $item->meta_keywords = $request->meta_keywords ?? '';
        $item->save();
        foreach ($request->types as $key => $type) {
            if (gettype($type) == 'array') {
                $lang = array_key_first($type);
                $type = $type[$lang];
                $business_settings = ServicesPagesall::where('type', $type)->where('id_service', $id)->first();
            } else {
                $business_settings = ServicesPagesall::where('type', $type)->where('id_service', $id)->first();
            }

            if ($business_settings != null) {
                if (gettype($request[$type]) == 'array') {
                    $business_settings->value = json_encode($request[$type]);
                } else {
                    $business_settings->value = $request[$type];
                }
                $business_settings->theme = get_setting('homepage_select');
                $business_settings->id_service = $id;
                $business_settings->save();
            } else {
                $business_settings = new ServicesPagesall;
                $business_settings->theme = get_setting('homepage_select');
                $business_settings->type = $type;
                $business_settings->id_service = $id;
                if (gettype($request[$type]) == 'array') {
                    $business_settings->value = json_encode($request[$type]);
                } else {
                    $business_settings->value = $request[$type];
                }
                $business_settings->save();
            }
        }

        Artisan::call('cache:clear');

        flash(translate("Configurações atualizadas com sucesso"))->success();
        if ($request->has('tab')) {
            return Redirect::to(URL::previous() . "#" . $request->tab);
        }
        return redirect()->back();
    }
}


